package com.ejie.ab04b.model;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.nora.Localidad;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Provincia;

/**
 * Ab0467s00 generated by UDA, 21-Feb-2017 12:47:20.
 * 
 * @author UDA
 */

public class DatosLocalizacion implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private Integer codLocalizacion067;
	private Provincia provincia;
	private String codComarca067;
	private Municipio municipio;
	private Localidad localidad;
	private String calle067;
	private String portal067;
	private String codpostal067;
	private String piso067;
	private String puerta067;

	/**
	 * Method 'Ab0467s00'.
	 */
	public DatosLocalizacion() {
	}

	/**
	 * Method 'Ab0467s00'.
	 * 
	 *  codLocalizacion067
	 *            Integer
	 *
	 * @param codLocalizacion067 the cod localizacion 067
	 */
	public DatosLocalizacion(Integer codLocalizacion067) {
		this.codLocalizacion067 = codLocalizacion067;
	}

	/**
	 * Method 'Ab0467s00'.
	 * 
	 *  codLocalizacion067
	 *            Integer
	 *  provincia
	 *            Provincia
	 *  codComarca067
	 *            String
	 *  municipio
	 *            Municipio
	 *  localidad
	 *            Localidad
	 *  calle067
	 *            String
	 *  portal067
	 *            String
	 *  codpostal067
	 *            String
	 *  piso067
	 *            String
	 *  puerta067
	 *            String
	 *
	 * @param codLocalizacion067 the cod localizacion 067
	 * @param provincia the provincia
	 * @param codComarca067 the cod comarca 067
	 * @param municipio the municipio
	 * @param localidad the localidad
	 * @param calle067 the calle 067
	 * @param portal067 the portal 067
	 * @param codpostal067 the codpostal 067
	 * @param piso067 the piso 067
	 * @param puerta067 the puerta 067
	 */
	public DatosLocalizacion(Integer codLocalizacion067, Provincia provincia,
			String codComarca067, Municipio municipio, Localidad localidad,
			String calle067, String portal067, String codpostal067,
			String piso067, String puerta067) {
		this.codLocalizacion067 = codLocalizacion067;
		this.provincia = provincia;
		this.codComarca067 = codComarca067;
		this.municipio = municipio;
		this.localidad = localidad;
		this.calle067 = calle067;
		this.portal067 = portal067;
		this.codpostal067 = codpostal067;
		this.piso067 = piso067;
		this.puerta067 = puerta067;
	}

	/**
	 * Method 'getCodLocalizacion067'.
	 * 
	 *  Integer
	 *
	 * @return the cod localizacion 067
	 */

	public Integer getCodLocalizacion067() {
		return this.codLocalizacion067;
	}

	/**
	 * Method 'setCodLocalizacion067'.
	 * 
	 *  codLocalizacion067            Integer
	 *
	 * @param codLocalizacion067 the new cod localizacion 067
	 */

	public void setCodLocalizacion067(Integer codLocalizacion067) {
		this.codLocalizacion067 = codLocalizacion067;
	}

	/**
	 * Method 'getProvincia'.
	 * 
	 *  Provincia
	 *
	 * @return the provincia
	 */

	public Provincia getProvincia() {
		return this.provincia;
	}

	/**
	 * Method 'setProvincia'.
	 * 
	 *  provincia            Provincia
	 *
	 * @param provincia the new provincia
	 */

	public void setProvincia(Provincia provincia) {
		this.provincia = provincia;
	}

	/**
	 * Method 'getCodComarca067'.
	 * 
	 *  String
	 *
	 * @return the cod comarca 067
	 */

	public String getCodComarca067() {
		return this.codComarca067;
	}

	/**
	 * Method 'setCodComarca067'.
	 * 
	 *  codComarca067            String
	 *
	 * @param codComarca067 the new cod comarca 067
	 */

	public void setCodComarca067(String codComarca067) {
		this.codComarca067 = codComarca067;
	}

	/**
	 * Method 'getMunicipio'.
	 * 
	 *  Municipio
	 *
	 * @return the municipio
	 */

	public Municipio getMunicipio() {
		return this.municipio;
	}

	/**
	 * Method 'setMunicipio'.
	 * 
	 *  municipio            Municipio
	 *
	 * @param municipio the new municipio
	 */

	public void setMunicipio(Municipio municipio) {
		this.municipio = municipio;
	}

	/**
	 * Method 'getLocalidad'.
	 * 
	 *  Localidad
	 *
	 * @return the localidad
	 */

	public Localidad getLocalidad() {
		return this.localidad;
	}

	/**
	 * Method 'setLocalidad'.
	 * 
	 *  localidad            Localidad
	 *
	 * @param localidad the new localidad
	 */

	public void setLocalidad(Localidad localidad) {
		this.localidad = localidad;
	}

	/**
	 * Method 'getCalle067'.
	 * 
	 *  String
	 *
	 * @return the calle 067
	 */

	public String getCalle067() {
		return this.calle067;
	}

	/**
	 * Method 'setCalle067'.
	 * 
	 *  calle067            Long
	 *
	 * @param calle067 the new calle 067
	 */

	public void setCalle067(String calle067) {
		this.calle067 = calle067;
	}

	/**
	 * Method 'getPortal067'.
	 * 
	 *  String
	 *
	 * @return the portal 067
	 */

	public String getPortal067() {
		return this.portal067;
	}

	/**
	 * Method 'setCodNumportal067'.
	 * 
	 *  portal067            String
	 *
	 * @param portal067 the new portal 067
	 */

	public void setPortal067(String portal067) {
		this.portal067 = portal067;
	}

	/**
	 * Method 'getCodpostal067'.
	 * 
	 *  String
	 *
	 * @return the codpostal 067
	 */

	public String getCodpostal067() {
		return this.codpostal067;
	}

	/**
	 * Method 'setCodpostal067'.
	 * 
	 *  codpostal067            String
	 *
	 * @param codpostal067 the new codpostal 067
	 */

	public void setCodpostal067(String codpostal067) {
		this.codpostal067 = codpostal067;
	}

	/**
	 * Method 'getPiso067'.
	 * 
	 *  String
	 *
	 * @return the piso 067
	 */

	public String getPiso067() {
		return this.piso067;
	}

	/**
	 * Method 'setPiso067'.
	 * 
	 *  piso067            String
	 *
	 * @param piso067 the new piso 067
	 */

	public void setPiso067(String piso067) {
		this.piso067 = piso067;
	}

	/**
	 * Method 'getPuerta067'.
	 * 
	 *  String
	 *
	 * @return the puerta 067
	 */

	public String getPuerta067() {
		return this.puerta067;
	}

	/**
	 * Method 'setPuerta067'.
	 * 
	 *  puerta067            String
	 *
	 * @param puerta067 the new puerta 067
	 */

	public void setPuerta067(String puerta067) {
		this.puerta067 = puerta067;
	}

	/**
	 * Gets the direccion completa.
	 * 
	 *  String
	 *
	 * @return the direccion completa
	 */
	public String getDireccionCompleta() {
		StringBuilder sb = new StringBuilder();
		sb.append(this.getCalle067());
		sb.append(Constantes.ESPACIO);
		sb.append(this.portal067);
		sb.append(Constantes.COMA);
		sb.append(Constantes.ESPACIO);
		sb.append(this.piso067);
		//sb.append(Constantes.GRADO);
		sb.append(Constantes.ESPACIO);
		sb.append(this.puerta067);

		return sb.toString();
	}

	/**
	 * Intended only for logging and debugging.
	 * 
	 * Here, the contents of every main field are placed into the result.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	@Override()
	public String toString() {
		StringBuilder result = new StringBuilder();
		result.append(this.getClass().getName()).append(" Object { ");
		result.append(" [ codLocalizacion067: ")
				.append(this.codLocalizacion067).append(" ]");
		result.append(", [ codProvincia067: ").append(this.provincia)
				.append(" ]");
		result.append(", [ codComarca067: ").append(this.codComarca067)
				.append(" ]");
		result.append(", [ codMunicipio067: ").append(this.municipio)
				.append(" ]");
		result.append(", [ codLocalidad067: ").append(this.localidad)
				.append(" ]");
		result.append(", [ codCalle067: ").append(this.calle067).append(" ]");
		result.append(", [ codNumportal067: ").append(this.portal067)
				.append(" ]");
		result.append(", [ codpostal067: ").append(this.codpostal067)
				.append(" ]");
		result.append(", [ piso067: ").append(this.piso067).append(" ]");
		result.append(", [ puerta067: ").append(this.puerta067).append(" ]");
		result.append("}");
		return result.toString();
	}

}
